# Copyright (C) 2013-2023 Echelon Corporation.  All Rights Reserved.
# Use of this code is subject to your compliance with the terms of the
# Echelon IzoT(tm) Software Developer's Kit License Agreement which is
# available at www.echelon.com/license/izot_sdk/.

# IzoT resources contained in this file are generated by an automated
# database to source code conversion process.  Grammar and punctuation within
# the embedded documentation may not be correct, as this data is gathered and
# combined from several sources.
# Names of resources and fields or members defined within a resource are
# derived from the same sources.  Names, capitalization and aspects of source
# code formatting may fail to comply with PEP-8 and PEP-257 recommendations
# due to the automated generation of these IzoT definitions.
# Generated at 11-May-2023 17:11.

"""uiTestTarget2 userdefined profile, originally defined in resource file set
apollodev 90:00:01:06:00:00:00:00-4."""


import izot.resources.base
from P9000010600000000_4.userdefined import userdefined
import izot.resources.datapoints.hvac_status
import izot.resources.datapoints.hvac_mode
import izot.resources.datapoints.temp_setpt
import izot.resources.datapoints.occupancy
import izot.resources.datapoints.switch
import izot.resources.datapoints.switch_2
import izot.resources.datapoints.alarm_2
import izot.resources.datapoints.temp_p
import izot.resources.datapoints.color_2
import izot.resources.datapoints.count
import izot.resources.properties.sceneDef


class uiTestTarget2(izot.resources.base.Profile):
    """uiTestTarget2 userdefined profile.  """

    def __init__(self):
        super().__init__(
            key=20007,
            scope=4
        )
        self.datapoints['nvoHvacStatus'] = izot.resources.base.Profile.DatapointMember(
            doc="""HVAC status.  """,
            name='nvoHvacStatus',
            profile=self,
            number=1,
            datatype=izot.resources.datapoints.hvac_status.hvac_status,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nviHvacMode'] = izot.resources.base.Profile.DatapointMember(
            doc="""HVAC mode.  """,
            name='nviHvacMode',
            profile=self,
            number=2,
            datatype=izot.resources.datapoints.hvac_mode.hvac_mode,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nviTempSP'] = izot.resources.base.Profile.DatapointMember(
            doc="""Temperature """,
            name='nviTempSP',
            profile=self,
            number=3,
            datatype=izot.resources.datapoints.temp_setpt.temp_setpt,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nviOccupancy'] = izot.resources.base.Profile.DatapointMember(
            doc="""Occupancy """,
            name='nviOccupancy',
            profile=self,
            number=4,
            datatype=izot.resources.datapoints.occupancy.occupancy,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nviLampSw'] = izot.resources.base.Profile.DatapointMember(
            doc="""Switch """,
            name='nviLampSw',
            profile=self,
            number=5,
            datatype=izot.resources.datapoints.switch.switch,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nviLampSw_2'] = izot.resources.base.Profile.DatapointMember(
            doc="""Switch with scene and setting control.  An enhanced
            version of SNVT_switch with scene and setting controls similar to
            SNVT_scene and SNVT_setting.""",
            name='nviLampSw_2',
            profile=self,
            number=6,
            datatype=izot.resources.datapoints.switch_2.switch_2,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nvoLampFb'] = izot.resources.base.Profile.DatapointMember(
            doc="""Switch """,
            name='nvoLampFb',
            profile=self,
            number=7,
            datatype=izot.resources.datapoints.switch.switch,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nvoLampFb_sw2'] = izot.resources.base.Profile.DatapointMember(
            doc="""Switch with scene and setting control.  An enhanced
            version of SNVT_switch with scene and setting controls similar to
            SNVT_scene and SNVT_setting.""",
            name='nvoLampFb_sw2',
            profile=self,
            number=8,
            datatype=izot.resources.datapoints.switch_2.switch_2,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nvoAlarm'] = izot.resources.base.Profile.DatapointMember(
            doc="""Alarm status 2.  Used to report alarm status for a
            functional block or device.  Replaces SNVT_alarm.""",
            name='nvoAlarm',
            profile=self,
            number=9,
            datatype=izot.resources.datapoints.alarm_2.alarm_2,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nviAlarmSimulate'] = izot.resources.base.Profile.DatapointMember(
            doc="""Alarm status 2.  Used to report alarm status for a
            functional block or device.  Replaces SNVT_alarm.""",
            name='nviAlarmSimulate',
            profile=self,
            number=10,
            datatype=izot.resources.datapoints.alarm_2.alarm_2,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nvoEffectiveSP'] = izot.resources.base.Profile.DatapointMember(
            doc="""Temperature """,
            name='nvoEffectiveSP',
            profile=self,
            number=11,
            datatype=izot.resources.datapoints.temp_p.temp_p,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nviColor_2'] = izot.resources.base.Profile.DatapointMember(
            doc="""Color """,
            name='nviColor_2',
            profile=self,
            number=12,
            datatype=izot.resources.datapoints.color_2.color_2,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nvoColor_2'] = izot.resources.base.Profile.DatapointMember(
            doc="""Color """,
            name='nvoColor_2',
            profile=self,
            number=13,
            datatype=izot.resources.datapoints.color_2.color_2,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nviCount'] = izot.resources.base.Profile.DatapointMember(
            doc="""Absolute count.  """,
            name='nviCount',
            profile=self,
            number=14,
            datatype=izot.resources.datapoints.count.count,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nvoCount'] = izot.resources.base.Profile.DatapointMember(
            doc="""Absolute count.  """,
            name='nvoCount',
            profile=self,
            number=15,
            datatype=izot.resources.datapoints.count.count,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.properties['cpSceneTable'] = izot.resources.base.Profile.PropertyMember(
            doc="""LC Scene Definition.  """,
            name='cpSceneTable',
            profile=self,
            number=1,
            datatype=izot.resources.properties.sceneDef.sceneDef,
            array_size_min=4,
            array_size_max=4,
            default=b'\x00\x00\x00',
            mandatory=True
        )
        self._original_name = 'UFPTuiTestTarget2'
        self._definition = userdefined.add(self)
        self.finalize()


if __name__ == '__main__':
    # unit test code.
    item = uiTestTarget2()
    pass
